#include "game.h"

void NewEnemy(sFace* f, int* bezierlist, int bez_xoff, int bez_yoff, int hp, int shootcooldown)
{
	sEnemy* e = &enemies[active_enemies++];
	e->m.f = f;
	e->bezier_list = bezierlist;
	e->bezx = bez_xoff;
	e->bezy = bez_yoff;
	e->hp = hp;
	e->step = 256;
	e->currentcooldown = shootcooldown;
	e->shootcooldown = shootcooldown;
}

void FlushEnemy(int number)
{
	--active_enemies;
	if(number==active_enemies)
	{
		return;
	}

	sEnemy* src = &enemies[active_enemies];
	sEnemy* dst = &enemies[number];

	dst->m = src->m;
	dst->bezier_list = src->bezier_list;
	dst->bezx = src->bezx;
	dst->bezy = src->bezy;
	dst->step = src->step;
	dst->x = src->x;
	dst->y = src->y;
	dst->hp = src->hp;
	dst->shootcooldown = src->shootcooldown;
	dst->currentcooldown = src->currentcooldown;
}

void EnemiesUpdate(void)
{
	sEnemy* e;
	int i;
	for(i=0;i<active_enemies;i++)
	{
		e = &enemies[i];
		if(!e->currentcooldown--) {
			sBullet* b = &enemybullets[active_enemybullets++];
			b->xfixed = e->x<<8;
			b->yfixed = (e->y+10)<<8;
			b->xinc = 0;
			b->yinc = 0x180;
			e->currentcooldown = e->shootcooldown;
		}
		if(!e->step--) FlushEnemy(i--);
		else {
			e->x = CalcBezierPosition(e->bezier_list[0], e->bezier_list[2], e->bezier_list[4], e->bezier_list[6], e->step) + e->bezx;
			e->y = CalcBezierPosition(e->bezier_list[1], e->bezier_list[3], e->bezier_list[5], e->bezier_list[7], e->step) + e->bezy;
			e->m.x = e->x;
			e->m.y = e->y;
			DrawModel(&e->m);
		}
	}
}


